<?php
/**
 * SMS API Class for api.ir
 * ارسال پیامک OTP با استفاده از api.ir
 */

class SmsAPI {
    private $apiKey;
    private $baseUrl = 'https://api.api.ir/';
    private $testMode = true; // حالت تست (بدون ارسال واقعی پیامک)
    
    public function __construct() {
        // API Token from api.ir
        $this->apiKey = 'gBNrmdSuPeJmwaqF2Eq1DwWHuRCMM9MgGqlsb6LPPSaur7nbKm/rxJEyI7t/4FHN8vjNXJuixgPpILEqCuFwaFcKyMs5VuRFJ2yxjdlNDhQ=';
    }
    
    /**
     * ارسال کد OTP
     * @param string $mobile شماره موبایل (09123456789)
     * @param string $code کد OTP (6 رقمی)
     * @return array نتیجه ارسال
     */
    public function sendOTP($mobile, $code) {
        // حالت تست: فقط کد را در لاگ ذخیره می‌کند
        if ($this->testMode) {
            return $this->sendTestOTP($mobile, $code);
        }
        
        // حالت واقعی: ارسال به API
        $mobile = $this->formatMobile($mobile);
        
        $url = $this->baseUrl . 'v1/sms/send/pattern';
        
        $data = [
            'lineNumber' => '30007732009933',
            'mobile' => $mobile,
            'patternCode' => 'your_pattern_code', // باید از پنل api.ir دریافت شود
            'parameters' => [
                [
                    'name' => 'code',
                    'value' => $code
                ]
            ]
        ];
        
        return $this->makeRequest($url, $data);
    }
    
    /**
     * ارسال تستی (بدون API واقعی)
     * کد را در فایل لاگ ذخیره می‌کند
     */
    private function sendTestOTP($mobile, $code) {
        // ذخیره کد در فایل لاگ
        $logFile = __DIR__ . '/../otp-logs.txt';
        $logMessage = date('Y-m-d H:i:s') . " - Mobile: $mobile - Code: $code\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        
        // نمایش کد در صفحه (فقط برای تست)
        error_log("OTP Code for $mobile: $code");
        
        return [
            'success' => true,
            'message' => "کد تایید: $code (حالت تست - پیامک ارسال نشد)",
            'test_mode' => true,
            'code' => $code // فقط در حالت تست
        ];
    }
    
    /**
     * فرمت کردن شماره موبایل
     * 09123456789 -> 989123456789
     */
    private function formatMobile($mobile) {
        // حذف فاصله و کاراکترهای اضافی
        $mobile = preg_replace('/[^0-9]/', '', $mobile);
        
        // اگر با 0 شروع شود، حذف و اضافه 98
        if (substr($mobile, 0, 1) === '0') {
            $mobile = '98' . substr($mobile, 1);
        }
        
        // اگر با 98 شروع نشده، اضافه کن
        if (substr($mobile, 0, 2) !== '98') {
            $mobile = '98' . $mobile;
        }
        
        return $mobile;
    }
    
    /**
     * ارسال درخواست به API
     */
    private function makeRequest($url, $data) {
        $ch = curl_init($url);
        
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Accept: application/json',
            'Authorization: Bearer ' . $this->apiKey
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        if ($error) {
            return [
                'success' => false,
                'message' => 'خطا در ارتباط با سرویس پیامک: ' . $error
            ];
        }
        
        $result = json_decode($response, true);
        
        // لاگ کردن پاسخ برای دیباگ
        error_log("SMS API Response (HTTP $httpCode): " . $response);
        
        if ($httpCode == 200 || $httpCode == 201) {
            return [
                'success' => true,
                'message' => 'پیامک با موفقیت ارسال شد',
                'data' => $result
            ];
        } else {
            $errorMsg = 'خطا در ارسال پیامک';
            if (isset($result['message'])) {
                $errorMsg .= ': ' . $result['message'];
            }
            
            return [
                'success' => false,
                'message' => $errorMsg,
                'code' => $httpCode,
                'data' => $result
            ];
        }
    }
    
    /**
     * تولید کد OTP تصادفی 6 رقمی
     */
    public static function generateOTP() {
        return str_pad(rand(100000, 999999), 6, '0', STR_PAD_LEFT);
    }
    
    /**
     * فعال/غیرفعال کردن حالت تست
     */
    public function setTestMode($enabled) {
        $this->testMode = $enabled;
    }
    
    /**
     * ارسال پیامک عمومی (برای اعلان‌ها)
     * @param string $mobile شماره موبایل
     * @param string $message متن پیام
     * @return array نتیجه ارسال
     */
    public function sendSMS($mobile, $message) {
        // حالت تست: فقط در لاگ ذخیره می‌کند
        if ($this->testMode) {
            return $this->sendTestSMS($mobile, $message);
        }
        
        // حالت واقعی: ارسال به API
        $mobile = $this->formatMobile($mobile);
        
        $url = $this->baseUrl . 'v1/sms/send/normal';
        
        $data = [
            'lineNumber' => '30007732009933',
            'mobile' => $mobile,
            'message' => $message
        ];
        
        return $this->makeRequest($url, $data);
    }
    
    /**
     * ارسال تستی پیامک عمومی
     */
    private function sendTestSMS($mobile, $message) {
        // ذخیره در فایل لاگ
        $logFile = __DIR__ . '/../logs/sms-logs.txt';
        $logDir = dirname($logFile);
        if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true);
        }
        
        $logMessage = date('Y-m-d H:i:s') . " - Mobile: $mobile - Message: $message\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);
        
        error_log("SMS to $mobile: $message");
        
        return [
            'success' => true,
            'message' => 'پیامک در حالت تست ذخیره شد',
            'test_mode' => true
        ];
    }
}
