# 📂 لیست کامل فایل‌های پروژه

---

## 📄 فایل‌های اصلی (Root)

| فایل | توضیحات | آپلود |
|------|---------|-------|
| `index.php` | صفحه اصلی - نمایش لیست بسته‌های eSIM | 🇩🇪 آلمان |
| `login.php` | صفحه ورود و ثبت‌نام کاربران | 🇩🇪 آلمان |
| `checkout.php` | صفحه تکمیل خرید و پرداخت | 🇩🇪 آلمان |
| `dashboard.php` | داشبورد کاربر - نمایش سفارشات | 🇩🇪 آلمان |
| `order-view.php` | جزئیات یک سفارش + QR Code | 🇩🇪 آلمان |
| `proxy-payment.php` | ارسال درخواست پرداخت به سرور ایران | 🇩🇪 آلمان |
| `proxy-callback.php` | دریافت نتیجه پرداخت از زرین‌پال | 🇩🇪 آلمان |
| `proxy-handler.php` | **هندلر پرداخت (فقط روی سرور ایران)** | 🇮🇷 ایران |
| `logout.php` | خروج از حساب کاربری | 🇩🇪 آلمان |
| `install.php` | نصب و راه‌اندازی دیتابیس | 🇩🇪 آلمان |
| `.htaccess` | تنظیمات Apache و امنیت | 🇩🇪 آلمان |

---

## 📁 پوشه config/

| فایل | توضیحات | آپلود |
|------|---------|-------|
| `config.php` | تنظیمات اصلی سیستم، API، Session | 🇩🇪 آلمان |
| `database.php` | تنظیمات و توابع دیتابیس | 🇩🇪 آلمان |

---

## 📁 پوشه includes/

| فایل | توضیحات | آپلود |
|------|---------|-------|
| `header.php` | هدر سایت (منو، navigation) | 🇩🇪 آلمان |
| `footer.php` | فوتر سایت | 🇩🇪 آلمان |
| `functions.php` | توابع کمکی (user, order management) | 🇩🇪 آلمان |

---

## 📁 پوشه api/

| فایل | توضیحات | آپلود |
|------|---------|-------|
| `esim-api.php` | کلاس API برای eSIM Access | 🇩🇪 آلمان |

---

## 📁 فایل‌های مستندات

| فایل | توضیحات |
|------|---------|
| `README.md` | معرفی کامل پروژه |
| `INSTALLATION_GUIDE.md` | راهنمای نصب گام به گام |
| `UPLOAD_INSTRUCTIONS.txt` | دستورالعمل آپلود فایل‌ها |
| `FILES_LIST.md` | این فایل - لیست تمام فایل‌ها |

---

## 🗂️ ساختار کامل پروژه

```
esimnew/
│
├── 📁 config/
│   ├── config.php          ⚙️ تنظیمات اصلی
│   └── database.php        🗄️ دیتابیس
│
├── 📁 includes/
│   ├── header.php          🔝 هدر
│   ├── footer.php          🔽 فوتر
│   └── functions.php       🔧 توابع
│
├── 📁 api/
│   └── esim-api.php        🌐 API
│
├── 📁 admin/ (اختیاری)
│   └── index.php           👨‍💼 پنل مدیریت
│
├── 📁 assets/ (اختیاری)
│   ├── css/                🎨 استایل‌ها
│   ├── js/                 ⚡ جاوااسکریپت
│   └── images/             🖼️ تصاویر
│
├── index.php               🏠 صفحه اصلی
├── login.php               🔐 ورود/ثبت‌نام
├── checkout.php            🛒 خرید
├── dashboard.php           📊 داشبورد
├── order-view.php          📄 جزئیات سفارش
├── proxy-payment.php       💳 پرداخت (آلمان)
├── proxy-callback.php      ✅ بازگشت پرداخت
├── proxy-handler.php       🔄 هندلر (ایران)
├── logout.php              🚪 خروج
├── install.php             ⚙️ نصب
│
├── .htaccess               🛡️ امنیت
├── README.md               📖 راهنما
├── INSTALLATION_GUIDE.md   📘 نصب
├── UPLOAD_INSTRUCTIONS.txt 📋 آپلود
└── FILES_LIST.md           📂 این فایل
```

---

## 🎯 فایل‌های کلیدی برای ویرایش

### قبل از آپلود باید ویرایش شوند:

1. **config/database.php**
   ```php
   define('DB_USER', 'YOUR_DB_USER');
   define('DB_PASS', 'YOUR_DB_PASS');
   define('DB_NAME', 'YOUR_DB_NAME');
   ```

2. **config/config.php**
   ```php
   define('ESIM_ACCESS_CODE', 'YOUR_CODE');
   define('ESIM_SECURITY_KEY', 'YOUR_KEY');
   define('IRAN_SERVER_URL', 'https://payesim.matinacard.ir/proxy-handler.php');
   ```

3. **proxy-handler.php** (روی سرور ایران)
   ```php
   define('ZARINPAL_MERCHANT_ID', 'YOUR_MERCHANT_ID');
   ```

---

## 📊 آمار پروژه

- **تعداد کل فایل‌های PHP:** 16
- **تعداد فایل‌های Config:** 2
- **تعداد فایل‌های Include:** 3
- **تعداد فایل‌های API:** 1
- **تعداد صفحات اصلی:** 7
- **تعداد فایل‌های پرداخت:** 3
- **تعداد فایل‌های مستندات:** 4

---

## 🔐 فایل‌های حساس (نیاز به محافظت)

⚠️ این فایل‌ها باید محافظت شوند:

- ✅ `config/config.php` - اطلاعات API
- ✅ `config/database.php` - اطلاعات دیتابیس
- ✅ `proxy-handler.php` - Merchant ID
- ✅ `install.php` - بعد از نصب حذف شود

---

## 📦 چک‌لیست آپلود

### سرور آلمان (esim.matinacard.com):
- [ ] config/
- [ ] includes/
- [ ] api/
- [ ] index.php
- [ ] login.php
- [ ] checkout.php
- [ ] dashboard.php
- [ ] order-view.php
- [ ] proxy-payment.php
- [ ] proxy-callback.php
- [ ] logout.php
- [ ] install.php
- [ ] .htaccess

### سرور ایران (payesim.matinacard.ir):
- [ ] proxy-handler.php

---

**آماده آپلود! 🚀**

